﻿<?php
	include_once('header.php');
	$achievementHits = [];
	$achievementHits["hits"] = [];

	$sql1 = "SELECT id, name, token FROM achievements WHERE id = ?";
	
	if ($stmt = $user_home->prepareQuery($sql1)) {
		$stmt->bind_param('i', $_GET['id']);
		$stmt->execute();

		$stmt->store_result();
		$stmt->bind_result($achievementID, $achievementName, $achievementToken);
		$stmt->fetch();

		if ($stmt->num_rows == 1) {
			$achievementHits["name"] = $achievementName;
			$achievementHits["id"] = $achievementID;
		} else {
            
		}
		$stmt->free_result();
	}
	
	$sql2 = "SELECT user_id, add_datetime FROM {$achievementToken}_hits WHERE achievement_id=? ORDER BY add_datetime DESC";
	if ($stmt = $user_home->prepareQuery($sql2)) {
		$stmt->bind_param('i', $_GET['id']);
		$stmt->execute();
		$stmt->bind_result($userID, $date);
		while ($stmt->fetch()) {
			$achievementHits["hits"][] = array("userID" => $userID, "date" => $date);
		}
	}
?>
	<div id="message" style="display:none;">
		<div class="" id="alert">
			
		</div>
	</div>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="icon-list-alt"></i>
						<h3> <?= $achievementName; ?></h3>
					</div>
					<div class="widget-content">
						<table class="table table-bordered table-striped table-hover"  id="paginated">
							<thead class="thead-inverse">
                                <tr>
									<th><?= $lang['player_id']; ?></th>
                                    <th><?= $lang['score_date']; ?></th>
									<?php if($user_home->is_logged_in()) { ?>
										<th></th>
									<?php } ?>
                                </tr>
							</thead>
							<tbody>
							<?php if(count($achievementHits["hits"])==0) {
								if($user_home->is_logged_in()) {
									echo '<tr><td colspan="3"><div class="alert alert-danger">'.$lang["no_hit"].'</div></td></tr>';
								} else {
									echo '<tr><td colspan="2"><div class="alert alert-danger">'.$lang["no_hit"].'</div></td></tr>';
								}
							} ?>
                  <?php foreach ($achievementHits["hits"] as $hit) : ?>
                            <tr id="row<?php echo $hit['userID'];?>">
								<td><?= $hit["userID"]; ?></td>
                                <td><?= $hit["date"]; ?></td>
								<?php if($user_home->is_logged_in()) { ?>
									<td>
									<button type='button' class="btn btn-danger btn-sm" id="delete_button<?php echo $hit['userID'];?>" onclick="delete_hit('<?php echo $hit['userID'];?>', '<?= $achievementID; ?>', '<?= $achievementToken; ?>', '<?= $language; ?>');"><i class="fa icon-trash"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></button>
									</td>
								<?php } ?>
                            </tr>
                        <?php endforeach; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
<?php include_once('footer.php'); ?>